#!/bin/bash

basecommand=`basename $0`
show=echo

usage()
{
    echo " $basecommand (start|stop|cleanup) hostfile [absolute_path_to_mpd]"
    exit 1
}

do_start() 
{
    MPD_BIN=$1
    hostlist=$2
    node_id=0

    for node in $hostlist
    do
        if [ $node_id -lt 1 ] ; then 
	    echo "start the first daemon on $node ..."
	    ssh -n $node ${MPD_BIN}/mpd & 
	    if [ $? != 0 ] ; then 
		echo "Not able to start the first daemon" && exit 0
	    fi
	    sleep 4
	    trace_output=`ssh -n $node ${MPD_BIN}/mpdtrace | \
	    awk '{print $2}' | cut -d: -f1`
	    mpd_host=`echo $trace_output | cut -d_ -f1 `
	    mpd_port=`echo $trace_output | cut -d_ -f2 `
	    node_id=$(($node_id + 1))
	elif [ $node_id -eq 1 ] ; then
	    echo "Run: ssh -n $node $MPD_BIN/mpd -h $mpd_host -p $mpd_port &"
	    ssh -n $node "$MPD_BIN/mpd -h $mpd_host -p $mpd_port " &
	    sleep 2
	fi
    done
}

do_stop()
{
    MPD_BIN=$1
    hostlist=$2

    echo "Quit all daemons through any daemon... "
    for node in $hostlist
    do
	ssh -n $node "${MPD_BIN}/mpdallexit "
	test $? -eq 0 && echo "All daemons exited" && exit $?
	sleep 1
    done
}

do_cleanup()
{
    MPD_BIN=$1
    hostlist=$2

    echo "Sanity check of leftover mpd daemons.. "
    for node in $hostlist
    do
	echo "Cleanup on $node ..."
	ssh -n $node "${MPD_BIN}/mpdcleanup "
	sleep 1
    done
}

if [ $# -lt 2 ] ; then
  usage
else
    hostfile=$2
    hostlist=`cat $hostfile`

    if [ $# -gt 2 ] ; then  
	mpd_dir=$3
    else
	mpd_dir=${PWD}
    fi

    if [ x"$1" = x"start" ]; then
       do_start $mpd_dir "$hostlist"
    elif [ x"$1" = x"stop" ]; then
       do_stop $mpd_dir "$hostlist"
    elif [ x"$1" = x"cleanup" ]; then
       do_cleanup $mpd_dir "$hostlist"
    else
       usage
    fi 
fi

exit $?

